/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.menu;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModTags;
import com.tiviacz.travelersbackpack.inventory.CraftingContainerImproved;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FluidSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ResultSlotExt;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ToolSlotItemHandler;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.network.ClientboundUpdateRecipePacket;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.IntStream;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.network.PacketDistributor;

public class TravelersBackpackBaseMenu
extends AbstractContainerMenu {
    public Inventory inventory;
    public ITravelersBackpackContainer container;
    public CraftingContainerImproved craftSlots;
    public ResultContainer resultSlots = new ResultContainer();
    private final int BACKPACK_INV_START = 1;
    private final int BACKPACK_INV_END;
    private final int TOOL_START;
    private final int TOOL_END;
    private final int BUCKET_LEFT_IN;
    private final int BUCKET_LEFT_OUT;
    private final int BUCKET_RIGHT_IN;
    private final int BUCKET_RIGHT_OUT;
    private final int PLAYER_INV_START;
    private final int PLAYER_HOT_END;

    public TravelersBackpackBaseMenu(MenuType<?> type, int windowID, Inventory inventory, ITravelersBackpackContainer container) {
        super(type, windowID);
        this.inventory = inventory;
        this.container = container;
        this.craftSlots = new CraftingContainerImproved(container, this);
        this.BACKPACK_INV_END = 1 + container.getTier().getStorageSlotsWithCrafting() - 1;
        this.TOOL_START = this.BACKPACK_INV_END + 1;
        this.TOOL_END = this.TOOL_START + 1;
        this.BUCKET_LEFT_IN = this.TOOL_END + 1;
        this.BUCKET_LEFT_OUT = this.BUCKET_LEFT_IN + 1;
        this.BUCKET_RIGHT_IN = this.BUCKET_LEFT_OUT + 1;
        this.BUCKET_RIGHT_OUT = this.BUCKET_RIGHT_IN + 1;
        this.PLAYER_INV_START = this.BUCKET_RIGHT_OUT + 1;
        this.PLAYER_HOT_END = this.PLAYER_INV_START + 35;
        this.addCraftResult();
        this.addBackpackInventoryAndCraftingGrid(container);
        this.addToolSlots(container);
        this.addFluidSlots(container);
        this.addPlayerInventoryAndHotbar(inventory, inventory.f_35977_);
        this.m_6199_((Container)new RecipeWrapper((IItemHandlerModifiable)container.getCraftingGridHandler()));
    }

    public void addCraftResult() {
        this.m_38897_((Slot)new ResultSlotExt(this.container, this.inventory.f_35978_, this.craftSlots, this.resultSlots, 0, 226, 43 + this.container.getTier().getMenuSlotPlacementFactor()));
    }

    public void addBackpackInventoryAndCraftingGrid(ITravelersBackpackContainer container) {
        int j;
        int i;
        int slot = 0;
        if (this.container.getTier().getOrdinal() > Tiers.LEATHER.getOrdinal()) {
            for (i = 0; i < this.container.getTier().getOrdinal(); ++i) {
                for (j = 0; j < (this.container.getTier().getOrdinal() == Tiers.NETHERITE.getOrdinal() ? 9 : 8); ++j) {
                    this.m_38897_((Slot)new BackpackSlotItemHandler((IItemHandler)container.getHandler(), slot++, (this.container.getTier().getOrdinal() == Tiers.NETHERITE.getOrdinal() ? 44 : 62) + j * 18, 7 + i * 18));
                }
            }
        }
        if (this.container.getTier().getOrdinal() == Tiers.NETHERITE.getOrdinal()) {
            this.m_38897_((Slot)new BackpackSlotItemHandler((IItemHandler)container.getHandler(), slot++, 44, 79));
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 8; ++j) {
                if (j >= 5) {
                    this.m_38897_(new Slot((Container)this.craftSlots, j - 5 + i * 3, 152 + (j - 5) * 18, 7 + this.container.getTier().getMenuSlotPlacementFactor() + i * 18){

                        public boolean m_5857_(ItemStack stack) {
                            if (BackpackSlotItemHandler.BLACKLISTED_ITEMS.contains(stack.m_41720_())) {
                                return false;
                            }
                            return !(stack.m_41720_() instanceof TravelersBackpackItem) && !stack.m_204117_(ModTags.BLACKLISTED_ITEMS);
                        }
                    });
                    continue;
                }
                this.m_38897_((Slot)new BackpackSlotItemHandler((IItemHandler)container.getHandler(), slot++, 62 + j * 18, 7 + this.container.getTier().getMenuSlotPlacementFactor() + i * 18));
            }
        }
    }

    public void addPlayerInventoryAndHotbar(Inventory inventory, int currentItemIndex) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)inventory, x + y * 9 + 9, 44 + x * 18, 71 + this.container.getTier().getMenuSlotPlacementFactor() + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inventory, x, 44 + x * 18, 129 + this.container.getTier().getMenuSlotPlacementFactor()));
        }
    }

    public void addFluidSlots(ITravelersBackpackContainer container) {
        this.m_38897_((Slot)new FluidSlotItemHandler(container, container.getTier().getSlotIndex(Tiers.SlotType.BUCKET_IN_LEFT), 6, 7));
        this.m_38897_((Slot)new FluidSlotItemHandler(container, container.getTier().getSlotIndex(Tiers.SlotType.BUCKET_OUT_LEFT), 6, 37));
        this.m_38897_((Slot)new FluidSlotItemHandler(container, container.getTier().getSlotIndex(Tiers.SlotType.BUCKET_IN_RIGHT), 226, 7));
        this.m_38897_((Slot)new FluidSlotItemHandler(container, container.getTier().getSlotIndex(Tiers.SlotType.BUCKET_OUT_RIGHT), 226, 37));
    }

    public void addToolSlots(ITravelersBackpackContainer container) {
        this.m_38897_((Slot)new ToolSlotItemHandler(this.inventory.f_35978_, container, container.getTier().getSlotIndex(Tiers.SlotType.TOOL_UPPER), 44, 25 + container.getTier().getMenuSlotPlacementFactor()));
        this.m_38897_((Slot)new ToolSlotItemHandler(this.inventory.f_35978_, container, container.getTier().getSlotIndex(Tiers.SlotType.TOOL_LOWER), 44, 43 + container.getTier().getMenuSlotPlacementFactor()));
    }

    protected void canCraft(Level level, Player player) {
        if (!TravelersBackpackConfig.disableCrafting) {
            this.slotChangedCraftingGrid(level, player);
        }
    }

    public void m_6199_(Container container) {
        super.m_6199_(container);
        this.canCraft(this.inventory.f_35978_.f_19853_, this.inventory.f_35978_);
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.resultSlots && super.m_5882_(stack, slot);
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot slot = this.m_38853_(index);
        ItemStack result = ItemStack.f_41583_;
        if (slot != null && slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            result = stack.m_41777_();
            if (index >= 0 && index <= this.BUCKET_RIGHT_OUT) {
                if (index == 0) {
                    return this.handleShiftCraft(player, slot);
                }
                if (!this.m_38903_(stack, this.PLAYER_INV_START, this.PLAYER_HOT_END + 1, true)) {
                    return ItemStack.f_41583_;
                }
            }
            if (index >= this.PLAYER_INV_START) {
                if (!this.container.getSlotManager().getMemorySlots().isEmpty()) {
                    boolean isCraftingLocked = this.container.getSettingsManager().isCraftingGridLocked();
                    ArrayList<Pair<Integer, ItemStack>> craftingSlots = new ArrayList<Pair<Integer, ItemStack>>();
                    for (Pair<Integer, ItemStack> pair : this.container.getSlotManager().getMemorySlots()) {
                        if (isCraftingLocked) {
                            Slot slot1 = this.m_38853_((Integer)pair.getFirst() + 1);
                            if (slot1.f_40218_ instanceof CraftingContainerImproved) {
                                craftingSlots.add(pair);
                                continue;
                            }
                        }
                        if (!ItemStackUtils.isSameItemSameTags((ItemStack)pair.getSecond(), stack) || this.m_38853_((Integer)pair.getFirst() + 1).m_7993_().m_41613_() == this.m_38853_((Integer)pair.getFirst() + 1).m_7993_().m_41741_() || !this.m_38903_(stack, (Integer)pair.getFirst() + 1, (Integer)pair.getFirst() + 2, false)) continue;
                        break;
                    }
                    if (!craftingSlots.isEmpty()) {
                        Pair pair;
                        Iterator<Object> iterator = craftingSlots.iterator();
                        while (!(!iterator.hasNext() || ItemStackUtils.isSameItemSameTags((ItemStack)(pair = (Pair)iterator.next()).getSecond(), stack) && this.m_38853_((Integer)pair.getFirst() + 1).m_7993_().m_41613_() != this.m_38853_((Integer)pair.getFirst() + 1).m_7993_().m_41741_() && this.m_38903_(stack, (Integer)pair.getFirst() + 1, (Integer)pair.getFirst() + 2, false))) {
                        }
                    }
                }
                if (ToolSlotItemHandler.isValid(stack) && !this.m_38903_(stack, this.TOOL_START, this.TOOL_END + 1, false) && !this.moveItemStackTo(stack, 1, this.BACKPACK_INV_END + 1, false, true, false)) {
                    return ItemStack.f_41583_;
                }
                if (!this.moveItemStackTo(stack, 1, this.BACKPACK_INV_END + 1, false, true, false)) {
                    return ItemStack.f_41583_;
                }
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack.m_41613_() == result.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack);
        }
        return result;
    }

    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean fromLast, boolean bool, boolean isResult) {
        boolean skippedCrafting = false;
        boolean flag = false;
        int i = startIndex;
        if (fromLast) {
            i = endIndex - 1;
        }
        if (stack.m_41753_()) {
            while (!stack.m_41619_() && !(fromLast ? i < startIndex : i >= endIndex)) {
                Slot slot = (Slot)this.f_38839_.get(i);
                if (bool && (this.container.getSettingsManager().isCraftingGridLocked() || isResult) && slot.f_40218_ instanceof CraftingContainerImproved) {
                    i = fromLast ? --i : ++i;
                    skippedCrafting = true;
                    continue;
                }
                ItemStack itemstack = slot.m_7993_();
                if (!itemstack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.m_41613_() + stack.m_41613_();
                    if (j <= (maxSize = Math.min(slot.m_6641_(), stack.m_41741_()))) {
                        stack.m_41764_(0);
                        itemstack.m_41764_(j);
                        slot.m_6654_();
                        flag = true;
                    } else if (itemstack.m_41613_() < maxSize) {
                        stack.m_41774_(maxSize - itemstack.m_41613_());
                        itemstack.m_41764_(maxSize);
                        slot.m_6654_();
                        flag = true;
                    }
                }
                if (fromLast) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.m_41619_()) {
            i = fromLast ? endIndex - 1 : startIndex;
            while (!(fromLast ? i < startIndex : i >= endIndex)) {
                Slot slot1 = (Slot)this.f_38839_.get(i);
                if (bool && (this.container.getSettingsManager().isCraftingGridLocked() || isResult) && slot1.f_40218_ instanceof CraftingContainerImproved) {
                    i = fromLast ? --i : ++i;
                    skippedCrafting = true;
                    continue;
                }
                ItemStack itemstack1 = slot1.m_7993_();
                if (itemstack1.m_41619_() && this.mayPlace(slot1, stack)) {
                    if (stack.m_41613_() > slot1.m_6641_()) {
                        slot1.m_5852_(stack.m_41620_(slot1.m_6641_()));
                    } else {
                        slot1.m_5852_(stack.m_41620_(stack.m_41613_()));
                    }
                    slot1.m_6654_();
                    flag = true;
                    break;
                }
                if (fromLast) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (skippedCrafting && !isResult) {
            i = 43;
            bool = false;
            this.moveItemStackTo(stack, i, endIndex, fromLast, bool, false);
        }
        return flag;
    }

    public boolean mayPlace(Slot slot, ItemStack stack) {
        if (this.container.getSlotManager().isSlot((byte)1, slot.f_40219_ - 1)) {
            return slot.m_5857_(stack) && this.container.getSlotManager().getMemorySlots().stream().anyMatch(p -> (Integer)p.getFirst() + 1 == slot.f_40219_ && ItemStackUtils.isSameItemSameTags((ItemStack)p.getSecond(), stack));
        }
        return slot.m_5857_(stack);
    }

    protected boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean fromLast) {
        boolean flag = false;
        int i = startIndex;
        if (fromLast) {
            i = endIndex - 1;
        }
        if (stack.m_41753_()) {
            while (!stack.m_41619_() && !(!fromLast ? i >= endIndex : i < startIndex)) {
                Slot slot = (Slot)this.f_38839_.get(i);
                ItemStack itemstack = slot.m_7993_();
                if (!itemstack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.m_41613_() + stack.m_41613_();
                    if (j <= (maxSize = Math.min(slot.m_6641_(), stack.m_41741_()))) {
                        stack.m_41764_(0);
                        itemstack.m_41764_(j);
                        slot.m_6654_();
                        flag = true;
                    } else if (itemstack.m_41613_() < maxSize) {
                        stack.m_41774_(maxSize - itemstack.m_41613_());
                        itemstack.m_41764_(maxSize);
                        slot.m_6654_();
                        flag = true;
                    }
                }
                if (fromLast) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.m_41619_()) {
            i = fromLast ? endIndex - 1 : startIndex;
            while (!(!fromLast ? i >= endIndex : i < startIndex)) {
                Slot slot1 = (Slot)this.f_38839_.get(i);
                ItemStack itemstack1 = slot1.m_7993_();
                if (itemstack1.m_41619_() && this.mayPlace(slot1, stack)) {
                    if (stack.m_41613_() > slot1.m_6641_()) {
                        slot1.m_5852_(stack.m_41620_(slot1.m_6641_()));
                    } else {
                        slot1.m_5852_(stack.m_41620_(stack.m_41613_()));
                    }
                    slot1.m_6654_();
                    flag = true;
                    break;
                }
                if (fromLast) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public ItemStack handleShiftCraft(Player player, Slot resultSlot) {
        ItemStack outputCopy = ItemStack.f_41583_;
        if (resultSlot != null && resultSlot.m_6657_()) {
            this.craftSlots.checkChanges = false;
            Recipe recipe = this.resultSlots.m_7928_();
            while (recipe != null && recipe.m_5818_((Container)this.craftSlots, player.f_19853_)) {
                ItemStack recipeOutput = resultSlot.m_7993_().m_41777_();
                outputCopy = recipeOutput.m_41777_();
                recipeOutput.m_41720_().m_7836_(recipeOutput, player.f_19853_, player);
                if (!player.f_19853_.f_46443_ && !this.moveItemStackTo(recipeOutput, 1, this.PLAYER_HOT_END + 1, true, true, true)) {
                    this.craftSlots.checkChanges = true;
                    return ItemStack.f_41583_;
                }
                resultSlot.m_40234_(recipeOutput, outputCopy);
                resultSlot.m_6654_();
                if (!player.f_19853_.f_46443_ && recipeOutput.m_41613_() == outputCopy.m_41613_()) {
                    this.craftSlots.checkChanges = true;
                    return ItemStack.f_41583_;
                }
                this.resultSlots.m_6029_(recipe);
                resultSlot.m_142406_(player, recipeOutput);
            }
            this.craftSlots.checkChanges = true;
            this.slotChangedCraftingGrid(player.f_19853_, player);
            this.container.setDataChanged(1);
        }
        this.craftSlots.checkChanges = true;
        return this.resultSlots.m_7928_() == null ? ItemStack.f_41583_ : outputCopy;
    }

    public void slotChangedCraftingGrid(Level level, Player player) {
        if (!level.f_46443_) {
            ItemStack itemstack = ItemStack.f_41583_;
            Recipe oldRecipe = this.resultSlots.m_7928_();
            Recipe recipe = oldRecipe;
            if (recipe == null || !recipe.m_5818_((Container)this.craftSlots, level)) {
                recipe = level.m_7465_().m_44015_(RecipeType.f_44107_, (Container)this.craftSlots, level).orElse(null);
            }
            if (recipe != null) {
                itemstack = recipe.m_5874_((Container)this.craftSlots);
            }
            if (oldRecipe != recipe) {
                TravelersBackpack.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ClientboundUpdateRecipePacket(recipe, itemstack));
                this.resultSlots.m_6836_(0, itemstack);
                this.resultSlots.m_6029_(recipe);
            } else if (recipe != null && (recipe.m_5598_() || !recipe.getClass().getName().startsWith("net.minecraft") && !ItemStack.m_41728_((ItemStack)itemstack, (ItemStack)this.resultSlots.m_8020_(0)))) {
                TravelersBackpack.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ClientboundUpdateRecipePacket(recipe, itemstack));
                this.resultSlots.m_6836_(0, itemstack);
                this.resultSlots.m_6029_(recipe);
            }
        }
    }

    public void m_150399_(int slotId, int dragType, ClickType clickType, Player player) {
        if (this.container.getSlotManager().isSelectorActive((byte)0) || this.container.getSlotManager().isSelectorActive((byte)1)) {
            return;
        }
        super.m_150399_(slotId, dragType, clickType, player);
    }

    public void m_6877_(Player player) {
        if (this.container.getScreenID() != 3) {
            this.container.setDataChanged(10);
        }
        if (this.container.getScreenID() == 3) {
            if (this.container.getSlotManager().isSelectorActive((byte)0) || this.container.getSlotManager().isSelectorActive((byte)1)) {
                this.container.getSlotManager().setChanged();
            }
            this.container.setUsingPlayer(null);
        }
        if (this.container.getSlotManager().isSelectorActive((byte)0)) {
            this.container.getSlotManager().setSelectorActive((byte)0, false);
        }
        if (this.container.getSlotManager().isSelectorActive((byte)1)) {
            this.container.getSlotManager().setSelectorActive((byte)1, false);
        }
        this.playSound(player, this.container);
        TravelersBackpackBaseMenu.clearBucketSlots(player, this.container);
        super.m_6877_(player);
    }

    public static void clearBucketSlots(Player player, ITravelersBackpackContainer container) {
        if (container.getScreenID() == 1 || container.getScreenID() == 2) {
            IntStream.range(container.getTier().getSlotIndex(Tiers.SlotType.BUCKET_IN_LEFT), container.getTier().getSlotIndex(Tiers.SlotType.BUCKET_OUT_RIGHT) + 1).forEach(i -> TravelersBackpackBaseMenu.clearBucketSlot(player, container, i));
        }
    }

    public static void clearBucketSlot(Player player, ITravelersBackpackContainer container, int index) {
        if (!container.getHandler().getStackInSlot(index).m_41619_()) {
            ServerPlayer serverPlayer;
            if (!player.m_6084_() || player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).m_9232_()) {
                ItemStack stack = container.getHandler().getStackInSlot(index).m_41777_();
                container.getHandler().setStackInSlot(index, ItemStack.f_41583_);
                player.m_36176_(stack, false);
            } else {
                ItemStack stack = container.getHandler().getStackInSlot(index);
                container.getHandler().setStackInSlot(index, ItemStack.f_41583_);
                player.m_150109_().m_150079_(stack);
            }
        }
    }

    public void playSound(Player player, ITravelersBackpackContainer container) {
        for (int i = container.getTier().getSlotIndex(Tiers.SlotType.BUCKET_IN_LEFT); i <= container.getTier().getSlotIndex(Tiers.SlotType.BUCKET_OUT_RIGHT); ++i) {
            if (container.getHandler().getStackInSlot(i).m_41619_() || container.getScreenID() == 3) continue;
            player.f_19853_.m_5594_(player, player.m_20183_(), SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, (1.0f + (player.f_19853_.m_213780_().m_188501_() - player.f_19853_.m_213780_().m_188501_()) * 0.2f) * 0.7f);
            break;
        }
    }

    public boolean m_6875_(Player player) {
        return true;
    }
}

